import express from "express";
import {
  getAllProjects,
  getProjectById,
  createProject,
  updateProject,
  deleteProject,
  toggleFeatured,
  togglePublish,
} from "../controllers/projectController.js";
import { authenticate, optionalAuthenticate } from "../middleware/auth.js";
import { uploadProjectImages } from "../middleware/upload.js";

const router = express.Router();

// Public routes with optional authentication
// Featured projects are publicly accessible
// Non-featured projects require admin authentication (handled in controller)
router.get("/", optionalAuthenticate, getAllProjects);
router.get("/:id", optionalAuthenticate, getProjectById);

// Protected routes (require authentication)
router.post("/", authenticate, uploadProjectImages, createProject);
router.put("/:id", authenticate, uploadProjectImages, updateProject);
router.delete("/:id", authenticate, deleteProject);
router.patch("/:id/feature", authenticate, toggleFeatured);
router.patch("/:id/publish", authenticate, togglePublish);

export default router;
