import logger from "../utils/logger.js";

// Custom error handler middleware
const errorHandler = (err, req, res, next) => {
  // Log error using logger
  logger.error("Request error", err);

  // Default error
  const status = err.statusCode || err.status || 500;
  const message = err.message || "Internal Server Error";

  // Send error response
  res.status(status).json({
    success: false,
    error: {
      message,
      ...(process.env.NODE_ENV === "development" && {
        stack: err.stack,
        details: err,
      }),
    },
  });
};

export default errorHandler;
