/**
 * Application constants
 */

export const PROJECT_CONSTANTS = {
  MAX_IMAGES_PER_PROJECT: 10,
  MAX_TITLE_LENGTH: 300,
  MAX_DESCRIPTION_LENGTH: 5000,
  MAX_FILE_SIZE: 10 * 1024 * 1024, // 10MB
  DEFAULT_PAGE: 1,
  DEFAULT_LIMIT: 10,
  MAX_LIMIT: 100,
  DEFAULT_SORT_BY: "createdAt",
  DEFAULT_SORT_ORDER: "desc",
  STATUS: {
    DRAFT: "draft",
    PUBLISHED: "published",
  },
  LANGUAGE: {
    ENGLISH: "en",
    ARABIC: "ar",
    BOTH: "both",
  },
};

export const ALLOWED_IMAGE_TYPES = [
  "image/jpeg",
  "image/jpg",
  "image/png",
  "image/webp",
];

export const SORT_FIELDS = [
  "createdAt",
  "updatedAt",
  "srNo",
  "title.en",
  "title.ar",
];
