import express from "express";
import { login, getMe, logout } from "../controllers/authController.js";
import { authenticate } from "../middleware/auth.js";

const router = express.Router();

// Public routes
router.post("/login", login);

// Protected routes (require authentication)
router.get("/me", authenticate, getMe);
router.post("/logout", authenticate, logout);

export default router;
