import logger from "../utils/logger.js";

/**
 * Request/Response logging middleware
 * Simple logger that displays: method, timestamp, route, and time taken
 */
const requestLogger = (req, res, next) => {
  // Record start time
  const startTime = Date.now();

  // Store original end function
  const originalEnd = res.end;

  // Override end function to capture response details
  res.end = function (chunk, encoding) {
    // Calculate response time
    const responseTime = Date.now() - startTime;

    // Log the request with simplified format
    logger.logRequest(req, res, responseTime);

    // Call original end function
    originalEnd.call(this, chunk, encoding);
  };

  next();
};

export default requestLogger;
