# Projects API Postman Collection

Complete Postman collection for testing the Samaa Backend Projects API with bilingual support.

## Import Instructions

1. Open Postman
2. Click **Import** button
3. Import `Samaa_Backend_Projects.postman_collection.json`
4. Make sure you also have the **Samaa Backend - Development** environment imported (from auth collection)

## Collection Structure

```
Projects
├── Get All Projects
│   ├── Get All Projects (Both Languages)
│   ├── Get All Projects (English Only)
│   ├── Get All Projects (Arabic Only)
│   ├── Get Published Projects (Admin Only) ⚠️
│   ├── Get Featured Projects
│   ├── Search Projects (English)
│   ├── Search Projects (Arabic)
│   ├── Search Projects (Both Languages)
│   ├── Search Published Projects (Admin Only) ⚠️
│   └── Search Featured Projects
│
├── Get Project by ID
│   ├── Get Project (Both Languages)
│   ├── Get Project (English Only)
│   └── Get Project (Arabic Only)
│
├── Create Project
├── Update Project
├── Delete Project
├── Toggle Featured Status
└── Toggle Publish Status
```

## Environment Variables

The collection uses these environment variables (set in your environment):

- `base_url` - Base URL (default: `http://localhost:3000`)
- `auth_token` - JWT token (set automatically after login)
- `project_id` - Project MongoDB ID (set automatically after creating a project)
- `project_srNo` - Project sequential number (set automatically after creating a project)

## Query Parameters

### Language Parameter (`lang`)

All GET endpoints support the `lang` query parameter:

- `?lang=en` - Returns only English content (title and description as strings)
- `?lang=ar` - Returns only Arabic content (title and description as strings)
- No `lang` parameter - Returns both languages (title and description as objects with `en` and `ar` properties)

### Search Parameter (`search`)

The `getAllProjects` endpoint supports searching by project name:

- `?search=keyword` - Searches in both English and Arabic project titles
- Case-insensitive partial matching
- Can be combined with other filters (status, featuredOnHomepage, lang)
- Maximum 100 characters
- Searches both `title.en` and `title.ar` fields simultaneously

**Examples:**

- `?search=Luxury` - Search for "Luxury" in both languages
- `?search=فاخرة` - Search for Arabic term "فاخرة" in both languages
- `?search=Villa&lang=en&status=published` - Search "Villa" in published projects, return English only

## Usage Examples

### 1. Get All Projects in English

```
GET {{base_url}}/api/projects?lang=en&page=1&limit=10
```

**Response:**

```json
{
  "success": true,
  "data": {
    "projects": [
      {
        "_id": "...",
        "srNo": 1,
        "title": "Luxury Villa Interior",
        "description": "Elegant marble flooring...",
        "images": [...],
        "featuredOnHomepage": true,
        "status": "published"
      }
    ],
    "language": "en"
  }
}
```

### 2. Get All Projects in Arabic

```
GET {{base_url}}/api/projects?lang=ar&page=1&limit=10
```

### 3. Get Featured Projects

```
GET {{base_url}}/api/projects?featuredOnHomepage=true&lang=en
```

### 4. Search Projects

#### Search in English

```
GET {{base_url}}/api/projects?search=Luxury&lang=en&page=1&limit=10
```

#### Search in Arabic

```
GET {{base_url}}/api/projects?search=فاخرة&lang=ar&page=1&limit=10
```

#### Search with Filters

```
GET {{base_url}}/api/projects?search=Villa&status=published&featuredOnHomepage=true&lang=en
```

**Search Response:**

```json
{
  "success": true,
  "data": {
    "projects": [
      {
        "_id": "...",
        "srNo": 1,
        "title": "Luxury Villa Interior",
        "description": "...",
        ...
      }
    ],
    "pagination": {
      "page": 1,
      "limit": 10,
      "total": 5,
      "pages": 1
    },
    "language": "en",
    "isAdmin": false,
    "search": "Luxury"
  }
}
```

**Search Features:**

- ✅ Searches in both English and Arabic titles simultaneously
- ✅ Case-insensitive matching
- ✅ Partial word matching (e.g., "Lux" matches "Luxury")
- ✅ Can be combined with status, featured, and language filters
- ✅ Returns search term in response for reference
- ✅ Secure: Regex special characters are escaped

### 5. Create Project

1. Make sure you're logged in (token is set in environment)
2. Open **Create Project** request
3. Fill in the form data:
   - `title[en]` - English title
   - `title[ar]` - Arabic title
   - `description[en]` - English description
   - `description[ar]` - Arabic description
   - `featuredOnHomepage` - true/false
   - `status` - draft/published
   - `images` - Select image files (up to 10)
4. Click **Send**
5. Project ID will be automatically saved to `project_id` environment variable

### 6. Update Project

1. Use the saved `project_id` from environment
2. Open **Update Project** request
3. Update only the fields you want to change
4. To remove images, add `removeImages` field with JSON array: `["filename1.jpg", "filename2.jpg"]`

### 7. Delete Project

1. Use the saved `project_id` from environment
2. Open **Delete Project** request
3. Click **Send**
4. Project and all its images will be deleted

### 8. Toggle Publish Status

1. Use the saved `project_id` from environment
2. Open **Toggle Publish Status** request
3. Click **Send**
4. Project status will toggle between `draft` and `published`

**Note:** Only admins can access published projects. Published projects filter (`?status=published`) is restricted to admin only.

**Note:** Only admins can access published projects. Published projects filter is restricted to admin only.

## File Upload Notes

- **Max Files:** 10 images per project
- **Max File Size:** 10MB per file
- **Allowed Types:** JPEG, JPG, PNG, WEBP
- **Storage:** Files are stored in `uploads/projects/` directory
- **URL Format:** `/uploads/projects/{filename}`

## Query Parameters

### Get All Projects

- `lang` - Language filter (en/ar)
- `search` - Search term to search in project titles (searches both English and Arabic, case-insensitive, max 100 chars)
- `status` - Filter by status (draft/published) ⚠️ **Published status filter is ADMIN ONLY** - requires authentication
- `featuredOnHomepage` - Filter featured projects (true/false)
- `page` - Page number (default: 1)
- `limit` - Items per page (default: 10, max: 100)
- `sortBy` - Field to sort by (default: createdAt)
- `sortOrder` - Sort order (asc/desc, default: desc)

**⚠️ Access Control:**

- **Published projects** (`status=published`) are **ADMIN ONLY** - requires Bearer token authentication
- Non-admin users will receive `403 Forbidden` if they try to filter by published status
- Featured projects are publicly accessible regardless of published/draft status

### Get Project by ID

- `lang` - Language filter (en/ar)

## Tips

1. **Always login first** - Use the auth collection to login and get a token
2. **Check environment variables** - Make sure `base_url` and `auth_token` are set
3. **Use language parameter** - Add `?lang=en` or `?lang=ar` to GET requests for single language
4. **File uploads** - Use FormData mode for POST/PUT requests with images
5. **Project ID** - After creating a project, the ID is automatically saved for use in other requests
6. **Published projects** - ⚠️ Filtering by `status=published` requires admin authentication. Make sure you're logged in before using published projects endpoints.
7. **Access control** - Featured projects are public, but published projects are admin-only

## Troubleshooting

### 401 Unauthorized

- Make sure you're logged in
- Check that `auth_token` is set in environment
- Verify token hasn't expired

### 400 Bad Request

- Check that all required fields are provided
- Verify file sizes are under 10MB
- Ensure maximum 10 images per project

### 403 Forbidden

- **Published projects access** - Only admins can access published projects. Make sure you're authenticated as admin.
- **Non-featured projects** - Only admins can view non-featured projects. Authenticate with admin credentials.

### 404 Not Found

- Verify project ID is correct
- Check that `project_id` environment variable is set

### File Upload Issues

- Make sure files are image types (JPEG, JPG, PNG, WEBP)
- Check file sizes (max 10MB each)
- Verify you're using FormData mode in Postman

## Example Workflow

1. **Login** (from Auth collection)

   - Token is saved automatically

2. **Create Project**

   - Fill in bilingual fields
   - Upload images
   - Project ID is saved automatically

3. **Get Project (English)**

   - Use saved project ID
   - Add `?lang=en` query parameter

4. **Update Project**

   - Use saved project ID
   - Update fields as needed

5. **Get Featured Projects**

   - Use `?featuredOnHomepage=true&lang=en`

6. **Delete Project**
   - Use saved project ID
   - Project and images are deleted
