# Samaa Backend

Professional Node.js backend platform built with Express.js.

## Features

- 🚀 Express.js web framework
- 🔒 Security middleware (Helmet)
- 📝 Professional custom logging system with request/response tracking
- 🌐 CORS enabled
- 🔧 Environment variable configuration
- 📁 Organized project structure

## Prerequisites

- Node.js >= 18.0.0
- npm >= 9.0.0

## Installation

1. Install dependencies:
```bash
npm install
```

2. Create a `.env` file based on `.env.example`:
```bash
cp .env.example .env
```

3. Update the `.env` file with your configuration.

## Running the Application

### Development Mode
```bash
npm run dev
```
This will start the server with nodemon for automatic restarts on file changes.

### Production Mode
```bash
npm start
```

The server will start on `http://localhost:3000` (or the port specified in your `.env` file).

## Project Structure

```
backend-/
├── src/
│   ├── config/          # Configuration files
│   ├── controllers/     # Business logic controllers
│   ├── middleware/      # Custom middleware
│   │   ├── errorHandler.js    # Error handling middleware
│   │   ├── notFound.js        # 404 handler
│   │   └── requestLogger.js   # Request/response logger
│   ├── routes/          # API route definitions
│   ├── utils/           # Utility modules
│   │   └── logger.js    # Custom logging system
│   └── server.js        # Main application entry point
├── logs/                # Log files (if file logging enabled)
├── .env.example         # Environment variables template
├── .gitignore          # Git ignore rules
├── package.json        # Project dependencies and scripts
└── README.md           # Project documentation
```

## API Endpoints

### Health Check
- `GET /health` - Server health status

### API Root
- `GET /api` - API information

## Scripts

- `npm start` - Start the server
- `npm run dev` - Start the server in development mode with auto-reload
- `npm run lint` - Run ESLint
- `npm run lint:fix` - Fix ESLint errors automatically

## Environment Variables

See `.env.example` for available environment variables.

### Logging Configuration

- `LOG_LEVEL` - Logging level (ERROR, WARN, INFO, DEBUG). Defaults to DEBUG in development, INFO in production.
- `LOG_TO_FILE` - Enable file logging (true/false). When enabled, logs are written to `logs/` directory with daily rotation.

## Logging System

The application includes a professional, production-grade logging system with the following features:

### Features

- **Multiple Log Levels**: ERROR, WARN, INFO, DEBUG
- **Request/Response Logging**: Automatically logs all HTTP requests with:
  - Timestamp
  - HTTP method and URL
  - Status code (color-coded)
  - Response time
  - Client IP address
  - User agent
  - Request body (with sensitive data sanitization)
  - Query parameters and route parameters
- **Color-coded Console Output**: Different colors for different log levels and HTTP status codes
- **File Logging**: Optional file logging with daily rotation (enabled via `LOG_TO_FILE=true`)
- **Sensitive Data Protection**: Automatically redacts sensitive fields like passwords, tokens, API keys, etc.
- **Error Tracking**: Comprehensive error logging with stack traces

### Usage

The logger is automatically used for all requests. You can also use it manually in your code:

```javascript
import logger from './utils/logger.js';

logger.info('Application started');
logger.error('Something went wrong', error);
logger.warn('Warning message', { data: 'additional info' });
logger.debug('Debug information', { debug: 'data' });
```

## Development

### Adding New Routes

1. Create a route file in `src/routes/`
2. Import and mount it in `src/routes/index.js`
3. Mount the routes in `src/server.js`

### Adding Controllers

1. Create controller functions in `src/controllers/`
2. Import and use them in your route handlers

## License

ISC

